---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-lastlogin - 最終ログイン情報レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/lastlogin/lastlogin.c` 36-59行目（インクルード、グローバル変数）
- E-02: `usr.sbin/lastlogin/lastlogin.c` 61-77行目（utcmp_user/utcmp_time関数）
- E-03: `usr.sbin/lastlogin/lastlogin.c` 79-153行目（main関数）
- E-04: `usr.sbin/lastlogin/lastlogin.c` 157-167行目（output関数）
- E-05: `usr.sbin/lastlogin/lastlogin.c` 169-174行目（usage関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UTXDB_LASTLOGINデータベースから最終ログイン情報を取得 | E-03 (114行目, 125行目: setutxdb(UTXDB_LASTLOGIN, file)) | ○ |
| C-02 | ユーザー名10桁左詰め出力 | E-04 (162行目: `{:user/%-10s/%s}`) | ○ |
| C-03 | TTYデバイス名8桁左詰め出力 | E-04 (162行目: `{:tty/%-8s/%s}`) | ○ |
| C-04 | ホスト名22桁最大22文字出力 | E-04 (163行目: `{:from/%-22.22s/%s}`) | ○ |
| C-05 | ctime()形式24文字で日時出力 | E-04 (165行目: `{:login-time/%.24s/%.24s}`, ctime(&t)) | ○ |
| C-06 | xo_attr("seconds")で秒数属性出力 | E-04 (164行目) | ○ |
| C-07 | -fオプションでデータベースファイル指定 | E-03 (91-92行目) | ○ |
| C-08 | -rオプションで逆順（order = -1） | E-03 (93-94行目), E-02 (65行目, 76行目) | ○ |
| C-09 | -tオプションで時刻ソート（utcmp_time） | E-03 (97-98行目), E-02 (69-77行目) | ○ |
| C-10 | ユーザー指定時はgetutxuser()で個別取得 | E-03 (116行目) | ○ |
| C-11 | 全ユーザー時はgetutxent()ループ | E-03 (129行目) | ○ |
| C-12 | USER_PROCESSタイプのみ対象 | E-03 (130行目: u->ut_type != USER_PROCESS) | ○ |
| C-13 | 16件ずつrealloc | E-03 (132行目: ulistsize % 16 == 0) | ○ |
| C-14 | qsort()でソート | E-03 (142行目: qsort(ulist, ulistsize, sizeof(...), utcmp)) | ○ |
| C-15 | LASTLOGIN_XO_VERSION "1" | E-01 (50行目) | ○ |
| C-16 | last(1)の出力フォーマットを模倣 | E-04 (156行目コメント: "Duplicate the output of last(1)") | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 175行の単一ファイルで完結しており、全行を読了済み

## 6) レビュアーチェックリスト（最小）
- [ ] UTXDB_LASTLOGINデータベースのデフォルトパスと権限を確認
- [ ] ut_user/ut_line/ut_hostの最大文字数と出力列幅の整合性を確認
- [ ] libxo構造化出力時のJSON/XMLフォーマットの妥当性を確認
